/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs;

import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigEvent;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigListener;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigManager;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.net.Socket;
import java.util.Set;

public final class CommManager
implements FcsService,
OutboundConfigListener {
    private static final String TRACE_MASKT = "XRCSCMGT";
    private static final String TRACE_MASKF = "XRCSCMGF";
    private static final String TRACE_MASKD = "XRCSCMGD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-CommMgr");
    private static CommManager commManager = null;
    public static final FcsServiceId FCS_SERVICE_ID = new FcsServiceId("com.ibm.hwmca.fw.rcs", 1.0);

    private CommManager() {
        OutboundConfigManager outConfigMgr = OutboundConfigManager.getOutboundConfigManager();
        OutboundConfigData outData = outConfigMgr.getOutboundConfig();
        if (outData.isCallHomeServer()) {
            FcsServer fcsServer = FcsServer.getFcsServer();
            fcsServer.addLocalService(FCS_SERVICE_ID, this);
        }
        outConfigMgr.addOutboundConfigListener(this);
        Trace.trace(TRACE_MASKT, "<> CommManager()");
    }

    public static synchronized CommManager getCommManager() {
        Trace.trace(TRACE_MASKT, "-> getCommManager()");
        if (commManager == null) {
            commManager = new CommManager();
        }
        Trace.trace(TRACE_MASKT, "<- getCommManager()");
        return commManager;
    }

    public void processConnection(FcsConnection connection) {
        Trace.trace(TRACE_MASKT, "-> processConnection()");
        try {
            Socket socket = connection.getSocket();
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKT, "<- processConnection()");
    }

    public Set getCallHomeServers() {
        Trace.trace(TRACE_MASKT, "-> getCallHomeServers()");
        FcsServer fcsServer = FcsServer.getFcsServer();
        Set servers = fcsServer.getSupportingMachines(FCS_SERVICE_ID, 7);
        Trace.trace(TRACE_MASKT, "<- getCallHomeServers()" + servers.size());
        return servers;
    }

    public void outboundConfigChanged(OutboundConfigEvent event) {
        Trace.trace(TRACE_MASKT, "-> outboundConfigChanged()");
        OutboundConfigData outConfigData = event.getOutboundConfigData();
        FcsServer fcsServer = FcsServer.getFcsServer();
        if (outConfigData.isCallHomeServer()) {
            if (fcsServer.getService(FCS_SERVICE_ID) == null) {
                fcsServer.addLocalService(FCS_SERVICE_ID, this);
            }
        } else if (fcsServer.getService(FCS_SERVICE_ID) != null) {
            fcsServer.removeLocalService(FCS_SERVICE_ID);
        }
        Trace.trace(TRACE_MASKT, "<- outboundConfigChanged()");
    }
}

